<?php $__env->startSection('title', 'Roles'); ?>

<?php $__env->startSection('content_header'); ?>
<h1>Users and Roles</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if(session('success_message')): ?>
        <div class="alert alert-info">
            <?php echo e(session('success_message')); ?>

        </div>
    <?php endif; ?>
    <div class="card">
        <div class="card-body">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col">User</th>
                        <th scope="col">Email</th>
                        <th scope="col">Role</th>
                        <th scope="col" colspan="2">Role Actions</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th><?php echo e($user->id); ?></th>
                            <td><?php echo e($user->full_name); ?></td>
                            <td><?php echo e($user->email); ?></td>
                            <td><?php echo e(count($user->roles) >0? $user->roles->first()->name : ""); ?></td>


                            <td width="10px"><a href="<?php echo e(route('users.edit', $user)); ?>" class="btn btn-primary btn-sm mb-2">Assign</a>
                            </td>

                            <td width="10px">
                                <form action="<?php echo e(route('users.destroy', $user)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <input type="submit" value="Delete" class="btn btn-danger btn-sm">
                                </form>
                            </td>

                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="text-center mt-3">
                <?php echo e($users->links()); ?>

            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Server\php\laravel\blog\resources\views/admin/users/index.blade.php ENDPATH**/ ?>