<?php $__env->startSection('title', 'Roles'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Roles</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if(session('success_message')): ?>
        <div class="alert alert-info">
            <?php echo e(session('success_message')); ?>

        </div>
    <?php endif; ?>
    <div class="card">
        <div class="card-header">
            <a class="btn btn-primary" href="<?php echo e(route('roles.create')); ?>">Create</a>
        </div>
        <div class="card-body">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Rol</th>
                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($role->id); ?></td>
                            <td><?php echo e($role->name); ?></td>

                            <td width="10px"><a href="<?php echo e(route('roles.edit',$role)); ?>" class="btn btn-primary btn-sm mb-2">Edit</a></td>

                            <td width="10px">
                                <form action="<?php echo e(route('roles.destroy',$role)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <input type="submit" value="Delete" class="btn btn-danger btn-sm">
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Server\php\laravel\blog\resources\views/admin/roles/index.blade.php ENDPATH**/ ?>