<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<html>

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="UTF-8">
    <link rel="icon" href="<?php echo e(asset('img/icono.ico')); ?>">

    <!-- Estilos de bootstrap -->
   <link href="<?php echo e(mix('css/app.css')); ?>" rel="stylesheet" >
    <!-- Estilos css generales -->
    <link href="<?php echo e(asset('css/base/general.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/base/menu.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/base/footer.css')); ?>" rel="stylesheet">

    <!-- Estilos cambiantes -->
    <?php echo $__env->yieldContent('styles'); ?>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title> <?php echo $__env->yieldContent('title'); ?> </title>
</head>

<body>

    <div class="content">
        <!-- Incluir menú -->
        <?php echo $__env->make('layouts.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <section class="section">
            <?php echo $__env->yieldContent('content'); ?>
        </section>

        <!-- Incluir footer -->
        <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php echo $__env->yieldContent('scripts'); ?>
    <!-- Scripts de bootstrap -->
    <script type="text/javascript" src="<?php echo e(mix('js/app.js')); ?>"></script>
</body>

</html>
<?php /**PATH C:\Server\php\laravel\blog\resources\views/layouts/base.blade.php ENDPATH**/ ?>