<?php $__env->startSection('title', 'Edit Article'); ?>

<?php $__env->startSection('content_header'); ?>
<h2>Update Article</h2>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('articles.update', $article)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="form-group"><input type="hidden" name="id" value="<?php echo e($article->id); ?>"></div>
                <div class="form-group">
                    <label>Title</label>
                    <input type="text" class="form-control" id="title" name='title' minlength="5"
                    maxlength="255" value="<?php echo e($article->title); ?>" oninput="slugify(this, 'slug')">

                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger">
                            <span>* <?php echo e($message); ?></span>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-group">
                    <label for="">Slug</label>
                    <input type="text" class="form-control" id="slug" name='slug'
                    placeholder="Slug del artículo" readonly value="<?php echo e($article->slug); ?>">
                </div>

                <div class="form-group">
                    <label>Introduction</label>
                    <input type="text" class="form-control" id="introduction" name='introduction'
                    minlength="5" maxlength="255" value="<?php echo e($article->introduction); ?>">

                    <?php $__errorArgs = ['introduction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger">
                            <span>* <?php echo e($message); ?></span>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-group">
                    <label>Change image</label>
                    <input type="file" class="form-control-file mb-2" id="image" name='image'>

                    <div class="rounded mx-auto d-block">
                        <img src="<?php echo e(asset('storage/'. $article->image)); ?>" style="width: 250px">
                    </div>

                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger">
                            <span>* <?php echo e($message); ?></span>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>


                <div class="form-group">
                    <label for="">Article Body</label>
                    <textarea class="form-control" id="body" name="body"><?php echo e($article->body); ?></textarea>

                    <?php $__errorArgs = ['body'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger">
                            <span>* <?php echo e($message); ?></span>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <label>Status</label>
                <div class="form-group">
                    <div class="form-check form-check-inline">
                        <label class="form-check-label">Private</label>
                        <input class="form-check-input ml-2" type="radio" name='status' id="status" value="0" <?php echo e($article->status == 0? "checked": ""); ?>>
                    </div>

                    <div class="form-check form-check-inline">
                        <label class="form-check-label">Public</label>
                        <input class="form-check-input ml-2" type="radio" name='status' id="status" value="1" <?php echo e($article->status == 1? "checked": ""); ?>>
                    </div>

                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger">
                            <span>* <?php echo e($message); ?></span>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-group">
                    <select class="form-control" name="category_id" id="category_id">
                        <option>Seleccione una categoría</option>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>" <?php echo e($article->category_id == $category->id ? "selected" : ""); ?>><?php echo e($category->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                    <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger">
                            <span>* <?php echo e($message); ?></span>
                        </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <input type="submit" value="Modify Article" class="btn btn-primary">
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <!-- Include the TinyMCE and Slugify functionality -->
    <?php echo $__env->make('components.editorTinyMCE', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script type="text/javascript" src="<?php echo e(asset('js/general.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Server\php\laravel\blog\resources\views/admin/articles/edit.blade.php ENDPATH**/ ?>