<?php $__env->startSection('title', 'Articles'); ?>
<?php $__env->startSection('content-header'); ?>
    <h2>Articles</h2>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php if(session('success_message')): ?>
        <div class="alert alert-info">
            <?php echo e(session('success_message')); ?>

        </div>
    <?php endif; ?>
    <div class="card">
        <div class="card-header">
            <a class="btn btn-primary" href="<?php echo e(route('articles.create')); ?>">Create</a>
        </div>

        <div class="card-body">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Category</th>
                        <th>Status</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(Str::limit($article->title,25, '...')); ?></td>
                            <td><?php echo e($article->category->name); ?></td>
                            <td>
                                <input type="checkbox" name="status" id="status" class="form-check-input ml-4"
                                disabled <?php echo e($article->status? "checked" : ""); ?>>
                            </td>

                            <td width="2px"><a href="<?php echo e(route('articles.show',$article )); ?>"
                                    class="btn btn-primary btn-sm mb-2">Show</a></td>

                            <td width="5px"><a href="<?php echo e(route('articles.edit',$article )); ?>"
                                    class="btn btn-primary btn-sm mb-2">Edit</a></td>

                            <td width="5px">
                                <form action="<?php echo e(route('articles.destroy',$article )); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <input type="submit" value="Delete" class="btn btn-danger btn-sm">
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tbody>
            </table>
            <div class="text-center mt-3">
                <?php echo e($articles->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Server\php\laravel\blog\resources\views/admin/articles/index.blade.php ENDPATH**/ ?>