<?php $__env->startSection('title', 'Categories'); ?>

<?php $__env->startSection('content_header'); ?>
<h2>Categories</h2>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if(session('success_message')): ?>
    <div class="alert alert-info">
        <?php echo e(session('success_message')); ?>

    </div>
    <?php endif; ?>
    <div class="card">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.create')): ?>
            <div class="card-header">
                <a class="btn btn-primary" href="<?php echo e(route('categories.create')); ?>">Create</a>
            </div>
        <?php endif; ?>


        <div class="card-body">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Status</th>
                        <th>Featured</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($category->name); ?></td>
                            <td>
                                <input type="checkbox" name="status" id="status" class="form-check-input ml-3"
                                    disabled <?php echo e($category->status? "checked": ""); ?>>
                            </td>
                            <td>
                                <input type="checkbox" name="is_featured" id="is_featured" class="form-check-input ml-4" <?php echo e($category->is_featured? "checked": ""); ?>

                                    disabled>
                            </td>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.edit')): ?>
                                <td width="10px"><a href="<?php echo e(route('categories.edit', $category)); ?>"
                                        class="btn btn-primary btn-sm mb-2">Edit</a></td>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.destroy')): ?>
                                <td width="10px">
                                    <form action="<?php echo e(route('categories.destroy', $category)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <input type="submit" value="Delete" class="btn btn-danger btn-sm">
                                    </form>
                                </td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="text-center mt-3">
                <?php echo e($categories->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Server\php\laravel\blog\resources\views/admin/categories/index.blade.php ENDPATH**/ ?>