<?php $__env->startSection('title', 'Categories'); ?>

<?php $__env->startSection('content_header'); ?>
<h2>Update Category</h2>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('categories.update', $category)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="form-group"><input type="hidden" name="id" value="<?php echo e($category->id); ?>"></div>

                <div class="form-group">
                    <label for="">Name</label>
                    <input type="text" class="form-control" id="name" name='name' placeholder="Nombre de la categoría" value="<?php echo e($category->name); ?>"  oninput="slugify(this, 'slug')">

                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="text-danger">
                        <span>*<?php echo e($message); ?></span>
                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-group">
                    <label for="">Slug</label>
                    <input type="text" class="form-control" id="slug" name='slug' placeholder="Nombre de la categoría" value="<?php echo e($category->slug); ?>" readonly>

                    <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="text-danger">
                        <span>*<?php echo e($message); ?></span>
                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-group">
                    <label>Image</label>
                    <input type="file" class="form-control-file mb-2" id="image" name='image'>

                    <div class="rounded mx-auto d-block">
                        <img src="<?php echo e(asset('storage/'. $category->image)); ?>" style="width: 250px">
                    </div>

                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="text-danger">
                        <span>*<?php echo e($message); ?></span>
                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>


                <label for="">Status</label>
                <div class="form-group">
                    <div class="form-check form-check-inline">
                        <label class="form-check-label" for="">Private</label>
                        <input class="form-check-input ml-2" type="radio" name='status' id="status" value="0" <?php echo e($category->status? "" : "checked"); ?>>
                    </div>

                    <div class="form-check form-check-inline">
                        <label class="form-check-label" for="">Public</label>
                        <input class="form-check-input ml-2" type="radio" name='status' id="status" value="1" <?php echo e($category->status? "checked" : ""); ?>>
                    </div>

                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="text-danger">
                        <span>*<?php echo e($message); ?></span>
                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <label for="">Featured</label>
                <div class="form-group">
                    <div class="form-check form-check-inline">
                        <label class="form-check-label">No</label>
                        <input class="form-check-input ml-2" type="radio" name='is_featured' id="is_featured" value="0" <?php echo e($category->is_featured? "" : "checked"); ?>>
                    </div>

                    <div class="form-check form-check-inline">
                        <label class="form-check-label">Yes</label>
                        <input class="form-check-input ml-2" type="radio" name='is_featured' id="is_featured" value="1" <?php echo e($category->is_featured? "checked" : ""); ?>>
                    </div>

                    <?php $__errorArgs = ['is_featured'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="text-danger">
                        <span>*<?php echo e($message); ?></span>
                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <input type="submit" value="Update" class="btn btn-primary">
            </form>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript" src="<?php echo e(asset('js/general.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Server\php\laravel\blog\resources\views/admin/categories/edit.blade.php ENDPATH**/ ?>